	% Example 9.15 
	clear all
	close all
	clc
	N = 5;
	wT0 = (0:0.01:0.8)'*pi;
	D = -4.5*wT0;
	W0 = ones(length(wT0),1);
	tol = 10^-10; delta = 10;
	alfa = 0.5*(-D + N*wT0);
	A = sin(wT0*(N-1:-1:0)-alfa*ones(1,N));
	b = -sin(N*wT0-alfa); 
	d = A\b;
	d0 = [1; d];	d1 = d0;	% Initial solution
	while delta > tol 
		den = abs(polyval(d0, exp(i*wT0)));
		W = W0./den;
		d2 = diag(W)*A\(diag(W)*b);
		delta = max(abs(d - d2));
		d = d2;	d0 = [1; d];
	end
	P = roots(d0)
	Z = 1./P
	G = real(prod(1-P)/prod(1-Z)) 
	figure(1)
	PLOT_PZ_Z(Z, P)
	
	figure(2)
%	wT = linspace(0, pi, 1000);
	Phase = PZ_2_PHASE_Z(G, 1./P, P, wT0');
	subplot(2,1,1)
	PLOT_DEVIATION_Z(wT0, unwrap(Phase)-D')
	grid on
	%	zoom on
	
	Taug = PZ_2_TG_Z(1, 1./P, P, wT0');
	subplot(2,1,2)
	PLOT_DELTA_TG_Z(wT0, Taug-4.4, 0, 0.2)
 
	
	
